require "datatest"

template = {} -- to store data templates

--datatest = datatest or {}

--[[
  Control fields in template are:
  VALUE     Indicates a terminal datum; 
            it is any value of the expected type.
  CONTAINS  Indicates a non-terminal datum; it is a
            table with the sub-structure of the branch.
  TEST      A function to check the value in case of terminal data.
  STRICT    true if the field cannot contain other fields
            not provided in CONTAINS.
  ALLSTRICT true if the CONTAINS fields and all embedded ones
            cannot contain other fields not given in the corresponding CONTAINS. 
  OPTIONAL  true if the field is optional.
  DEFAULT   default value for an optional field if not provided.

  Table templates can be recursively nested through VALUE fields
  to any depth.
--]]

local positive  = datatest.numrange(0, math.huge)
local purecolor = {VALUE = 1, TEST = datatest.numrange(0, 1)}
local rgbcolor = {r = purecolor, g = purecolor, b = purecolor}

-- a box template
template.box = {
 ALLSTRICT = true,
 CONTAINS = {
  id = {VALUE = "a box"},
  place = {VALUE = "front",
           TEST = datatest.inset({"front", "back", "spine"}, string.lower)
          },
  fill     = {OPTIONAL = true, CONTAINS = {color = {CONTAINS = rgbcolor}}},
  -- adjust is more complete than in the text (gem28)
  adjust   = {CONTAINS = {horizontal = {VALUE = "l", OPTIONAL = true, DEFAULT = "l",
                                    TEST = datatest.inset({"l", "c", "r"}, string.lower)
                                   },
                          vertical = {VALUE = "b", OPTIONAL = true, DEFAULT = "l",
                                    TEST = datatest.inset({"t", "m", "b"}, string.lower)
                                   }},
              OPTIONAL = true, DEFAULT = {horizontal = "l", vertical = "b"}
             },
  angle    = {VALUE = 0, OPTIONAL = true, DEFAULT = 0},
  position = {CONTAINS = {x = {VALUE = 0}, y = {VALUE = 0}}},
  border = {OPTIONAL = true, 
            CONTAINS = {color = {CONTAINS = rgbcolor},
                        linewidth = {VALUE = 0.5, TEST = positive}},
            DEFAULT = {color = {r = 0, g = 1, b = 1}, linewidth = 0.5}
           },
  width = {VALUE = 10, TEST = positive},
  height = {VALUE = 20, TEST = positive},
  more = {VALUE = {{1, "a"}, {2, "b"}, {3, "c"}},
          OPTIONAL = true,
          TEST = datatest.listof({1, "z"})}
         }
}

-- an arc template
template.arc = {
 CONTAINS = {
  id = {VALUE = "an arc", OPTIONAL = true},
  place = {VALUE = "front",
           TEST = datatest.inset({"front", "back", "spine"}, string.lower)
          },
  fill  = {OPTIONAL = true, CONTAINS = {color = {CONTAINS = rgbcolor}}},
  border = {OPTIONAL = true, CONTAINS = {color = {CONTAINS = rgbcolor},
                                         linewidth = {VALUE = 0.5, TEST = positive}},
            DEFAULT = {color = {r = 1, g = 0, b = 1}, linewidth = 0.5}
           },
  radius = {VALUE = 2, TEST = positive},
  startangle = {VALUE = 0, OPTIONAL = true, DEFAULT = 0},
  endangle = {VALUE = 360, OPTIONAL = true, DEFAULT = 360},
  center = {STRICT = true, CONTAINS = {x = {VALUE = 0}, y = {VALUE = 0}}},
 }
}

